package org.simantics.scl.compiler.internal.parsing.types;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.kinds.Kind;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;



public class TPlainEffectAst extends TypeAst {
    public final TypeAst[] effects;
    
    public TPlainEffectAst(TypeAst[] effects) {
        this.effects = effects;
    }
    
    public TPlainEffectAst(ArrayList<TypeAst> effects) {
        this(effects.toArray(new TypeAst[effects.size()]));
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("<<");
        boolean first = true;
        for(TypeAst effect : effects) {
            if(first)
                first = false;
            else
                b.append(",");
            effect.toString(b);
        }
        b.append(">>");
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        return TFunctionAst.toEffect(context, effects);
    }
    
    @Override
    public Type toType(TypeElaborationContext context) {
        return TFunctionAst.toEffect(context, effects);
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap,
            TIntHashSet set) {
        for(TypeAst effect : effects)
            effect.collectReferences(typeNameMap, set);
    }
}
