package org.simantics.scl.compiler.internal.parsing;

import org.simantics.scl.compiler.errors.Locations;

/**
 * This class is the base class for all the nodes in an SCL abstract syntax tree.
 * All nodes share a property {@link #location} that links the node
 * to a position in the SCL source.
 */
public abstract class Symbol {
    public long location = Locations.NO_LOCATION;
    
    public long getLocation() {
        return location;
    }
}
