package org.simantics.scl.compiler.internal.elaboration.constraints2;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

class ConstraintResolution {
    public static final int INSTANCE_PRIORITY = 1;
    public static final int SUPERCLASS_PRIORITY = 2;
    public static final int GIVEN_PRIORITY = 3;
    
    public final Constant function;
    public final Type[] typeParameters;
    public final ConstraintHandle[] parameters;
    public final int priority;
    
    public ConstraintResolution(Constant function, Type[] typeParameters,
            ConstraintHandle[] parameters, int priority) {
        this.function = function;
        this.typeParameters = typeParameters;
        this.parameters = parameters;
        this.priority = priority;
    }

    public String toString(TypeUnparsingContext tuc) {
        StringBuilder b = new StringBuilder();
        b.append(function);
        for(Type typeParameter : typeParameters)
            b.append(" <").append(typeParameter.toString(tuc)).append('>');
        for(ConstraintHandle parameter : parameters)
            b.append(" (").append(parameter.constraint.toString(tuc)).append(')');
        return b.toString();
    }
}
