package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.errors.Locations;

public class RuleStatement extends Statement {

    public Expression head;
    public Query body;

    public RuleStatement(Expression head, Query body) {
        this.head = head;
        this.body = body;
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, BlockType blockType, Expression in) {
        throw new UnsupportedOperationException();
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            head.setLocationDeep(loc);
            body.setLocationDeep(loc);
        }
    }
    
    @Override
    public void resolvePattern(TranslationContext context) {
        head = head.resolveAsPattern(context);
    }
    
    @Override
    public boolean mayBeRecursive() {
        return true;
    }
    
    @Override
    public Statement replace(ReplaceContext context) {
        return new RuleStatement(head.replaceInPattern(context), body.replace(context));
    }
    
    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StatementGroup getStatementGroup() {
        return StatementGroup.Rule;
    }
}
