package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public abstract class ASTExpression extends SimplifiableExpression {
    public ASTExpression() {
    }
    
    @Override
    final public Expression simplify(SimplificationContext context) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support simplify.");
    }
    
    @Override
    final protected void updateType() throws MatchException {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support updateType.");
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support accept.");
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support accept.");
    }
    
    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        throw new InternalCompilerError("Class " + 
                getClass().getSimpleName() + " does not implement method checkBasicType.");
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        throw new InternalCompilerError("Class " + 
                getClass().getSimpleName() + " does not implement method inferType.");
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION)
            location = loc;
    }
}
