package org.simantics.scl.compiler.elaboration.equation;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public abstract class Equation extends Symbol {
    public static final Equation[] EMPTY_ARRAY = new Equation[0];    

    public abstract void setLocationDeep(long loc);

    public abstract void checkType(TypingContext context);
    public abstract void resolve(TranslationContext context);
    public abstract void accept(EquationVisitor visitor);
    public abstract Equation replace(ReplaceContext context);

}
