package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class ExecuteOp extends PlanOp {
    Expression expression;
    
    public ExecuteOp(long location, Expression expression) {
        super(location);
        this.expression = expression;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("EXECUTE ").append(expression);

    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        expression.toVal(context, w);
        planContext.nextOp(w);
    }

}
