package org.simantics.scl.compiler.constants.singletons;

import java.util.Arrays;

import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TypeOfConstant extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    public static final TypeOfConstant INSTANCE = new TypeOfConstant();
    
    private TypeOfConstant() {
        super(new TVar[] {A}, Types.NO_EFFECTS, Types.TYPE, 
                Types.pred(Types.TYPEABLE, A), A);
    }
    
    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        mb.push(parameters[0], Types.TYPE);
        return getReturnType();
    }
    
    @Override
    public String toString() {
        return "typeOf";
    }
    
    @Override
    public void inline(SSASimplificationContext context, LetApply apply) {
        ValRef[] parameters = apply.getParameters();
        if(parameters.length == 2) {
            parameters[1].remove();
            apply.setParameters(Arrays.copyOf(parameters, 1));
        }
        ValRef oldFunc = apply.getFunction();
        apply.setFunction(TypeValueConstant.INSTANCE.createOccurrence(oldFunc.getTypeParameters()));
        oldFunc.remove();
        context.markModified("inline-typeOf");
    }
}