package org.simantics.scl.compiler.compilation;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public interface TypeInferableDefinition {
    long getLocation();
    Collection<Object> getDefinedObjects();
    void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs);
    
    void initializeTypeChecking(TypingContext context);
    void checkType(TypingContext context);
    void solveConstraints();
    void collectFreeTypeVariables(THashSet<TVar> varSet);
    ArrayList<Variable> getFreeEvidence();
    void injectEvidence(TVar[] vars, TPred[] constraints);
    ArrayList<Constraint> getUnsolvedConstraints();
}
