/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JRadioButton;

public class RadioButtonListNode extends ComponentNode<Box> implements ActionListener {
    /**
     * 
     */
    private static final long serialVersionUID = 7073028693751719102L;

    protected boolean editable = true;
    protected Object value = "";
    protected String tooltip = "";
    protected double borderWidth = 0;

    protected transient ActionListener actionListener = null;

    protected Font font = null;
    protected Color color = null;
    protected Map<String, JRadioButton> items = new HashMap<String, JRadioButton>();
    
    @Override
    public String toString() {
        return super.toString() + "[editable=" + editable + ", value=" + value + "]";
    }
    
    @Override
    public void init() {
        component = new Box(BoxLayout.Y_AXIS);
        component.setEnabled(editable);
        component.setLocation(0, 0);
        
        super.init();
    }

    @SyncField("items")
    public void setItems(List<String> items) {
    	this.items.clear();
        component.removeAll();
        for(String item : items) {
	        JRadioButton btn = new JRadioButton();
	        btn.setText(item);
	        btn.addActionListener(this);
	        component.add(btn);
	        this.items.put(item, btn);
        }
        if(items.size() > 0)
        	((JRadioButton)component.getComponent(0)).setSelected(true); // First item selected

        component.doLayout();
    }

    @SyncField("editable")
    public void setEditable(boolean value) {
        this.editable = value;

        if(component != null) {
            component.setEnabled(value);
        }
    }

    @PropertySetter("Stroke Width")
    @SyncField("borderWidth")
    public void setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth;
//        if(component != null) {
//            ((TextField)component).setBorder(borderWidth);
//        }
    }

    @SyncField("value")
    public void setValue(Object value) {
        this.value = value;
        // RemoteViewer does not have component initialized
        if (component != null && value != null) {
    		JRadioButton b = items.get(value);
    		if(b != null) {
    			for(JRadioButton i : items.values()) {
    				if(i == b) {
    					i.setSelected(true);
    				} else {
    					i.setSelected(false);
    				}
    			}
    		}
        }
    }

    @SyncField("tooltip")
    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
        if (component != null) {
            component.setToolTipText(tooltip);
        }
    }

    @PropertySetter("Font")
    @SyncField("font")
    public void setFont(Font font) {
        this.font = font;
        if (component != null) {
            setComponentFont(font);
        }
    }

    @PropertySetter("Color")
    @SyncField("color")
    public void setColor(Color color) {
        this.color = color;
        if (component != null) {
            component.setForeground(color);
        }
    }

    public Object getValue() {
        return value;
    }

    public Font getFont() {
        return font;
    }
    
    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    /**
     * Wrapper method to send event to server side
     * 
     * @param e
     */
    @ServerSide
    public void performAction(ActionEvent e) {
        if (actionListener != null) {
            //System.out.println("MonitorNode.performAction(" + e + ")");
            actionListener.actionPerformed(e);
        }
    }
	@Override
	public void actionPerformed(ActionEvent e) {
		JRadioButton b = items.get(e.getActionCommand());
		if(b != null) {
			for(JRadioButton i : items.values()) {
				if(i == b) {
					i.setSelected(true);
				} else {
					i.setSelected(false);
				}
			}
		}
		performAction(e);
	}

}
