/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scenegraph.profile.ProfileEntry;

/**
 * @author Antti Villberg
 */
public class RuntimeProfileActiveEntries extends ResourceRead<Collection<ProfileEntry>> {

	private static Comparator<ProfileEntry> COMPARATOR = new Comparator<ProfileEntry>() {

		@Override
		public int compare(ProfileEntry arg0, ProfileEntry arg1) {
			return Double.compare(arg0.getPriority(), arg1.getPriority());
		}
		
	};
	
    public RuntimeProfileActiveEntries(Resource resource) {
        super(resource);
    }

    @Override
    public Collection<ProfileEntry> perform(ReadGraph graph) throws DatabaseException {
        ArrayList<ProfileEntry> result = new ArrayList<ProfileEntry>();
        for (Resource entry : graph.syncRequest(new RuntimeProfileActiveEntryResources(resource))) {
            result.add(graph.adapt(entry, ProfileEntry.class));
        }
        Collections.sort(result, COMPARATOR);
//        for(ProfileEntry e : result) System.err.println("-RuntimeProfileActiveEntries: " + e + " " + e.getPriority());
        return result;
    }

}
