/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile;

import org.simantics.scenegraph.INode;

/**
 * An interface for diagram profile styles for accessing scene graph nodes based
 * on diagram data objects, which usually are database resources.
 * 
 * <p>
 * See {@link DataNodeConstants} for some predefined constants for accessing
 * certain scene graph nodes related to a diagram.
 * 
 * @author Antti Villberg
 * @see Style
 * @see INode
 * @see DataNodeConstants
 */
public interface DataNodeMap {

    INode getNode(Object data);

}
