/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.project.management.FeatureSpec;
import org.simantics.project.ontology.ProjectResource;

public class ProjectSpec {
    String name;
    String URI;
    List<FeatureSpec> features;
    transient List<FeatureSpec> features_read_only_view;
    transient int hash;
    static Read<List<ProjectSpec>> QUERY = new Read<List<ProjectSpec>>(){

        public List<ProjectSpec> perform(ReadGraph g) throws DatabaseException {
            ProjectResource pr = ProjectResource.getInstance((ReadGraph)g);
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            Resource root = g.getResource("http://Projects");
            TreeMap<String, ProjectSpec> result = new TreeMap<String, ProjectSpec>();
            TreeMap<String, FeatureSpec> features = new TreeMap<String, FeatureSpec>();
            for (Resource r : g.getObjects(root, L0.ConsistsOf)) {
                String URI2 = g.getURI(r);
                String name = (String)g.getPossibleRelatedValue(r, L0.HasName);
                features.clear();
                for (Resource r2 : g.getObjects(r, pr.HasFeature)) {
                    FeatureSpec spec = new FeatureSpec();
                    spec.versionedId = (String)g.getPossibleRelatedValue(r2, pr.HasGroupId, (Binding)Bindings.STRING);
                    spec.name = (String)g.getPossibleRelatedValue(r2, L0.HasName, (Binding)Bindings.STRING);
                    Boolean b = (Boolean)g.getPossibleRelatedValue(r2, pr.IsRequired, (Binding)Bindings.BOOLEAN);
                    spec.required = b != null ? b : true;
                    features.put(spec.versionedId, spec);
                }
                ProjectSpec spec = new ProjectSpec(name, URI2, new ArrayList<FeatureSpec>(features.values()));
                result.put(URI2, spec);
            }
            return new ArrayList<ProjectSpec>(result.values());
        }
    };

    public ProjectSpec(String name, String URI2, List<FeatureSpec> features) {
        this.name = name;
        this.URI = URI2;
        TreeMap<String, FeatureSpec> sortedList = new TreeMap<String, FeatureSpec>();
        for (FeatureSpec fs : features) {
            sortedList.put(fs.versionedId, fs);
        }
        this.features = new ArrayList(sortedList.values());
        this.features_read_only_view = Collections.unmodifiableList(this.features);
        this.hash = URI2.hashCode();
        for (FeatureSpec fs : this.features) {
            this.hash = 13 * this.hash + fs.hashCode();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        return this.URI;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSpec)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ProjectSpec other = (ProjectSpec)obj;
        if (!other.URI.equals(this.URI)) {
            return false;
        }
        if (other.features.size() != this.features.size()) {
            return false;
        }
        int c = this.features.size();
        int i = 0;
        while (i < c) {
            if (!this.features.get(i).equals(other.features.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<FeatureSpec> getFeatures() {
        return this.features;
    }
}

