/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.project.IProject;
import org.simantics.project.features.registry.GroupReference;
import org.simantics.project.internal.ProjectPolicy;
import org.simantics.project.internal.SafeName;
import org.simantics.project.ontology.ProjectResource;

public class Projects {
    public static String getName(RequestProcessor processor, IProject project) throws DatabaseException {
        return (String)processor.syncRequest((Read)new SafeName((Resource)project.get()));
    }

    public static Resource createProject(WriteGraph graph, String name) throws DatabaseException {
        Resource root = graph.getResource("http://Projects");
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        Resource project = graph.newResource();
        graph.claim(project, L0.InstanceOf, null, PROJ.Project);
        graph.claim(project, L0.PartOf, root);
        graph.claimLiteral(project, L0.HasName, (Object)name);
        return project;
    }

    public static Resource createProject(WriteGraph graph, String name, Collection<GroupReference> features) throws DatabaseException {
        Resource project = Projects.createProject(graph, name);
        Projects.setProjectInstalledGroups(graph, project, features);
        return project;
    }

    public static Map<String, Resource> getInstalledFeatures(ReadGraph graph, Resource project) throws DatabaseException {
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        if (ProjectPolicy.TRACE_PROJECT_MANAGEMENT) {
            System.out.println("Looking for installed groups in project '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)project) + "'");
        }
        HashMap<String, Resource> result = new HashMap<String, Resource>();
        for (Resource featureSpec : graph.getObjects(project, PROJ.HasFeature)) {
            Resource group = graph.getSingleObject(featureSpec, PROJ.HasGroupId);
            String groupId = (String)graph.getPossibleValue(group, (Binding)Bindings.STRING);
            if (groupId == null) continue;
            if (ProjectPolicy.TRACE_PROJECT_MANAGEMENT) {
                System.out.println("\t+ found existing feature group definition '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)group) + "'");
            }
            result.put(groupId, featureSpec);
        }
        return result;
    }

    public static Resource setProjectInstalledGroups(WriteGraph graph, Resource project, Collection<GroupReference> groups) throws DatabaseException {
        if (ProjectPolicy.TRACE_PROJECT_MANAGEMENT) {
            System.out.println("Setting installed groups for project '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)project) + "' to " + groups);
        }
        HashSet<String> groupStringsToAdd = new HashSet<String>();
        for (GroupReference ref : groups) {
            groupStringsToAdd.add(ref.toString());
        }
        Map<String, Resource> existing = Projects.getInstalledFeatures((ReadGraph)graph, project);
        HashSet<Resource> specsToRemove = new HashSet<Resource>();
        for (Map.Entry<String, Resource> entry : existing.entrySet()) {
            if (groupStringsToAdd.remove(entry.getKey())) {
                if (!ProjectPolicy.TRACE_PROJECT_MANAGEMENT) continue;
                System.out.println("\t= reusing existing definition: " + entry.getKey());
                continue;
            }
            if (ProjectPolicy.TRACE_PROJECT_MANAGEMENT) {
                System.out.println("\t- marking for removal: " + entry.getKey());
            }
            specsToRemove.add(entry.getValue());
        }
        for (Resource groupToRemove : specsToRemove) {
            Projects.uninstallGroup(graph, project, groupToRemove);
        }
        for (String groupString : groupStringsToAdd) {
            Projects.installGroup(graph, project, groupString);
        }
        return project;
    }

    public static Resource installGroup(WriteGraph graph, Resource project, String groupId) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        if (ProjectPolicy.TRACE_PROJECT_MANAGEMENT) {
            System.out.println("+ Installing group '" + groupId + "' to project '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)project) + "'");
        }
        Resource groupIdRes = graph.newResource();
        graph.claim(groupIdRes, L0.InstanceOf, null, L0.String);
        graph.claimValue(groupIdRes, (Object)groupId);
        Resource isRequiredRes = graph.newResource();
        graph.claim(isRequiredRes, L0.InstanceOf, null, L0.Boolean);
        graph.claimValue(isRequiredRes, (Object)true);
        Resource featureSpec = graph.newResource();
        graph.claim(featureSpec, L0.InstanceOf, null, PROJ.FeatureSpec);
        graph.claim(project, PROJ.HasFeature, featureSpec);
        graph.claim(featureSpec, PROJ.HasGroupId, groupIdRes);
        graph.claim(featureSpec, PROJ.IsRequired, isRequiredRes);
        return groupIdRes;
    }

    public static boolean uninstallGroup(WriteGraph graph, Resource project, String groupId) throws DatabaseException {
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        if (ProjectPolicy.TRACE_PROJECT_MANAGEMENT) {
            System.out.println("- Uninstalling group '" + groupId + "' from project '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)project) + "'");
        }
        for (Resource featureSpec : graph.getObjects(project, PROJ.HasFeature)) {
            Resource group = graph.getSingleObject(featureSpec, PROJ.HasGroupId);
            String existingGroup = (String)graph.getPossibleValue(group, (Binding)Bindings.STRING);
            if (groupId.equals(existingGroup)) {
                if (ProjectPolicy.TRACE_PROJECT_MANAGEMENT) {
                    System.out.println("\t - found it, removing");
                }
                graph.deny(featureSpec, PROJ.HasGroupId, group);
                EntityRemover.remove((WriteGraph)graph, (Resource)group, (boolean)false);
                return true;
            }
            graph.deny(project, PROJ.HasFeature, featureSpec);
            EntityRemover.remove((WriteGraph)graph, (Resource)featureSpec, (boolean)false);
        }
        return false;
    }

    public static boolean uninstallGroup(WriteGraph graph, Resource project, Resource featureSpec) throws DatabaseException {
        Resource groupId;
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        if (ProjectPolicy.TRACE_PROJECT_MANAGEMENT) {
            System.out.println("- Uninstalling group '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)featureSpec) + "' from project '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)project) + "'");
        }
        if ((groupId = graph.getPossibleObject(featureSpec, PROJ.HasGroupId)) != null) {
            graph.deny(featureSpec, PROJ.HasGroupId, groupId);
            EntityRemover.remove((WriteGraph)graph, (Resource)groupId, (boolean)false);
            return true;
        }
        if (graph.hasStatement(project, PROJ.HasFeature, featureSpec)) {
            graph.deny(project, PROJ.HasFeature, featureSpec);
            EntityRemover.remove((WriteGraph)graph, (Resource)featureSpec, (boolean)false);
            return true;
        }
        return false;
    }

    public static IProject loadProject(RequestProcessor processor, Resource project) throws DatabaseException {
        IProject p = (IProject)processor.syncRequest(Queries.adapt((Resource)project, IProject.class, (boolean)false, (boolean)true));
        return p;
    }

    public static void deleteProject(WriteGraph g, Resource project) throws DatabaseException {
        RemoverUtil.remove((WriteGraph)g, (Resource)project);
    }
}

