/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import java.util.Collection;
import java.util.Set;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.UndoMetadata;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Write;
import org.simantics.db.service.CollectionSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.adapters.ChangeHistoryUpdated;
import org.simantics.modeling.adapters.SkipChangeHistoryUpdate;
import org.simantics.modeling.utils.OntologicalRequirementEnforceRequest;

public class OntologicalRequirementTracker {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MODIFICATIONS = false;
    private static final boolean DEBUG_PROPAGATE = false;
    private Layer0 L0;
    private DiagramResource DIA;

    private void propagate(ReadGraph graph, Resource r, Set<Resource> rs) throws DatabaseException {
        if (!r.isPersistent()) {
            return;
        }
        if (!rs.add(r)) {
            return;
        }
        if (graph.isInstanceOf(r, this.L0.IndexRoot)) {
            return;
        }
        Resource owner = graph.getPossibleObject(r, this.L0.IsOwnedBy);
        if (owner == null) {
            return;
        }
        if (graph.isInstanceOf(r, this.DIA.DiagramContainer) && (owner = graph.getPossibleObject(owner, this.L0.PartOf)) == null) {
            return;
        }
        this.propagate(graph, owner, rs);
    }

    public void update(ReadGraph graph, MetadataI metadata, DependencyChanges event) throws DatabaseException {
        if (metadata != null) {
            boolean isUndo = metadata.getMetadata().containsKey(UndoMetadata.class.getName());
            boolean wasHistoryUpdate = metadata.getMetadata().containsKey(ChangeHistoryUpdated.class.getName());
            boolean skipUpdate = metadata.getMetadata().containsKey(SkipChangeHistoryUpdate.class.getName());
            if (isUndo || wasHistoryUpdate || skipUpdate) {
                return;
            }
        }
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set work = cs.createSet();
        Set creates = cs.createSet();
        Set ids = cs.createSet();
        for (Resource model : event.modelChanges.keySet()) {
            DependencyChanges.Change[] changes = (DependencyChanges.Change[])event.modelChanges.get(model);
            if (changes == null || changes.length == 0) continue;
            DependencyChanges.Change[] changeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r;
                DependencyChanges.Change c = changeArray[n2];
                if (c instanceof DependencyChanges.ComponentModification) {
                    r = ((DependencyChanges.ComponentModification)c).component;
                    this.propagate(graph, r, work);
                }
                if (c instanceof DependencyChanges.ComponentAddition) {
                    boolean hasGUID;
                    r = ((DependencyChanges.ComponentAddition)c).component;
                    boolean hasChangeInformation = graph.hasStatement(r, MOD.changeInformation);
                    if (!hasChangeInformation && ModelingUtils.needsModificationInfo(graph, r)) {
                        creates.add(r);
                    }
                    if (!(hasGUID = graph.hasStatement(r, this.L0.identifier)) && ModelingUtils.needsIdentifier(graph, r)) {
                        ids.add(r);
                    }
                    this.propagate(graph, r, work);
                }
                ++n2;
            }
        }
        if (work.isEmpty()) {
            return;
        }
        Set modis = cs.createSet();
        for (Resource r : Layer0Utils.sortByCluster((ReadGraph)graph, (Collection)work)) {
            if (creates.contains(r) || !ModelingUtils.needsModificationInfo(graph, r)) continue;
            modis.add(r);
        }
        if (!(modis.isEmpty() && creates.isEmpty() && ids.isEmpty())) {
            graph.asyncRequest((Write)new OntologicalRequirementEnforceRequest(creates, modis, ids));
        }
    }
}

