/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class NewSubscriptionItem
extends WriteRequest {
    Resource subscription;
    Double interval;
    Double deadband;
    Double gain;
    Double bias;
    String unit;
    String label;
    RVI variableId;
    Datatype datatype;
    public Resource subscriptionItem;

    public NewSubscriptionItem(Resource subscription, Double interval, Double deadband, Double gain, Double bias, String unit, String label, RVI variableId, Datatype datatype) {
        this.subscription = subscription;
        this.interval = interval;
        this.deadband = deadband;
        this.gain = gain;
        this.bias = bias;
        this.unit = unit;
        this.label = label;
        this.variableId = variableId;
        this.datatype = datatype;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        this.subscriptionItem = graph.newResource();
        graph.claim(this.subscriptionItem, l0.InstanceOf, null, mr.Subscription_Item);
        graph.claim(this.subscription, l0.ConsistsOf, this.subscriptionItem);
        graph.claimLiteral(this.subscriptionItem, l0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(this.subscriptionItem, l0.HasLabel, (Object)this.label, (Binding)Bindings.STRING);
        if (this.datatype != null) {
            graph.claimLiteral(this.subscriptionItem, mr.Subscription_Item_Datatype, l0.DataType, (Object)this.datatype, Bindings.getBindingUnchecked(Datatype.class));
        }
        if (this.interval != null) {
            graph.claimLiteral(this.subscriptionItem, mr.Subscription_Item_SamplingInterval, (Object)this.interval, (Binding)Bindings.DOUBLE);
        }
        if (this.deadband != null) {
            graph.claimLiteral(this.subscriptionItem, mr.Subscription_Item_Deadband, (Object)this.deadband, (Binding)Bindings.DOUBLE);
        }
        if (this.unit != null) {
            graph.claimLiteral(this.subscriptionItem, mr.Subscription_Item_Unit, (Object)this.unit, (Binding)Bindings.STRING);
        }
        if (this.gain != null) {
            graph.claimLiteral(this.subscriptionItem, mr.Subscription_Item_Gain, (Object)this.gain, (Binding)Bindings.DOUBLE);
        }
        if (this.bias != null) {
            graph.claimLiteral(this.subscriptionItem, mr.Subscription_Item_Bias, (Object)this.bias, (Binding)Bindings.DOUBLE);
        }
        Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
        graph.claimLiteral(this.subscriptionItem, mr.Subscription_Item_VariableId, l0.RVI, (Object)this.variableId, rviBinding);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Added new subscription " + this.label + " " + this.subscriptionItem + " "));
    }
}

