/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.modeling.SCLTypeUtils;
import org.simantics.modeling.scl.SCLNodeManager;
import org.simantics.modeling.scl.SCLSessionManager;
import org.simantics.modeling.scl.SCLState;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.simulator.variable.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLRealm
implements Realm {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLRealm.class);
    public static final String SCL = "scl";
    private THashMap<String, Type> contextTypes = new THashMap();
    private CommandSession connection;
    private String id;
    private Thread executorThread;
    private SCLRealmThreadFactory factory = new SCLRealmThreadFactory(this);
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.factory);
    private Semaphore beginSyncExec = new Semaphore(0);
    private Semaphore endSyncExec = new Semaphore(0);
    private SCLNodeManager nodeManager;
    private Runnable scheduleSyncExec = new Runnable(){

        @Override
        public void run() {
            SCLRealm.this.beginSyncExec.release();
            try {
                SCLRealm.this.endSyncExec.acquire();
            }
            catch (InterruptedException interruptedException) {}
        }
    };

    SCLRealm(CommandSession connection, String id) {
        this.connection = connection;
        this.id = id;
        this.nodeManager = new SCLNodeManager(this);
    }

    public String getId() {
        return this.id;
    }

    public CommandSession getConnection() {
        return this.connection;
    }

    public Thread getThread() {
        return this.executorThread;
    }

    public Object syncExec(Function fun) throws InterruptedException {
        this.executor.execute(this.scheduleSyncExec);
        SCLContext context = SCLContext.getCurrent();
        CommandSession oldConnection = (CommandSession)context.put((Object)SCL, (Object)this.connection);
        try {
            this.beginSyncExec.acquire();
            Thread oldThread = this.executorThread;
            this.executorThread = Thread.currentThread();
            try {
                Object object = fun.apply((Object)Tuple0.INSTANCE);
                this.executorThread = oldThread;
                this.endSyncExec.release();
                return object;
            }
            catch (Throwable throwable) {
                this.executorThread = oldThread;
                this.endSyncExec.release();
                throw throwable;
            }
        }
        finally {
            context.put((Object)SCL, (Object)oldConnection);
        }
    }

    public void asyncExec(final Function fun) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                SCLContext context = SCLContext.getCurrent();
                context.put((Object)SCLRealm.SCL, (Object)SCLRealm.this.connection);
                fun.apply((Object)Tuple0.INSTANCE);
            }
        });
    }

    public void syncExec(Runnable runnable) throws InterruptedException {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Runnable failed in syncExec.", t);
            }
            return;
        }
        this.executor.execute(this.scheduleSyncExec);
        this.beginSyncExec.acquire();
        Thread oldThread = this.executorThread;
        this.executorThread = Thread.currentThread();
        try {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Runnable failed in syncExec.", t);
                this.executorThread = oldThread;
                this.endSyncExec.release();
            }
        }
        finally {
            this.executorThread = oldThread;
            this.endSyncExec.release();
        }
    }

    public void asyncExec(Runnable runnable) {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Runnable failed in asyncExec.", t);
            }
            return;
        }
        this.executor.execute(runnable);
    }

    public void refreshVariables() {
        this.nodeManager.refreshVariables();
    }

    public void refreshVariablesSync() {
        this.nodeManager.refreshVariablesSync();
    }

    public void close() {
        SCLSessionManager.CONNECTIONS.remove(this.id);
        this.executor.shutdown();
        try {
            List<Runnable> runnables;
            if (!this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS) && !(runnables = this.executor.shutdownNow()).isEmpty()) {
                LOGGER.info("Some runnables left to execute in realm " + this + ": " + runnables);
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("Could not shutdown executor " + this.executor + " in realm " + this, (Throwable)e);
        }
        this.factory.clear();
        this.factory = null;
        if (this.executorThread.isAlive()) {
            this.executorThread.interrupt();
        }
        this.executorThread = null;
        this.executor = null;
        this.nodeManager.clear();
    }

    public SCLNodeManager getNodeManager() {
        return this.nodeManager;
    }

    private SCLState getState() {
        SCLState state = new SCLState();
        for (String key : this.connection.getVariables()) {
            Object value = this.connection.getVariableValue(key);
            try {
                Binding b = Bindings.getBinding(value.getClass());
                state.values.put(key, new Variant(b, value));
            }
            catch (Exception exception) {}
        }
        return state;
    }

    public void applyState(byte[] blob) {
        try {
            SCLState state = (SCLState)SCLState.BINDING.serializer().deserialize(blob);
            for (Map.Entry<String, Variant> entry : state.values.entrySet()) {
                String key = entry.getKey();
                Variant value = entry.getValue();
                Type type = SCLTypeUtils.getType(value.type());
                if (type.getClassId() == 6) continue;
                this.connection.setVariable(key, type, value.getValue());
            }
        }
        catch (RuntimeSerializerConstructionException runtimeSerializerConstructionException) {
        }
        catch (IOException iOException) {}
    }

    public byte[] serialize() {
        SCLState state = this.getState();
        try {
            return SCLState.BINDING.serializer().serialize((Object)state);
        }
        catch (RuntimeSerializerConstructionException runtimeSerializerConstructionException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void setThread(Thread t) {
        this.executorThread = t;
    }

    private static class SCLRealmThreadFactory
    implements ThreadFactory {
        private SCLRealm realm;

        public SCLRealmThreadFactory(SCLRealm realm) {
            this.realm = realm;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            this.realm.setThread(t);
            return t;
        }

        void clear() {
            this.realm = null;
        }
    }
}

