/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.ElementRemover;
import org.simantics.modeling.utils.RemoverUtils;

public class TerminalRemover
extends ElementRemover {
    public TerminalRemover(Resource terminal) {
        super(terminal);
    }

    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource diagramConnectionRelation : graph.getObjects(this.resource, DIA.HasConnectionPoint)) {
            for (Resource connectionRelation : graph.getObjects(diagramConnectionRelation, MOD.DiagramConnectionRelationToConnectionRelation)) {
                RemoverUtils.ValidationResult result = RemoverUtils.validateConnectionRelationRemoval(graph, connectionRelation, diagramConnectionRelation);
                if (!result.inUse()) continue;
                return RemoverUtils.formatError(graph, result);
            }
        }
        return null;
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource diagramConnectionPoint : graph.getObjects(this.resource, DIA.HasConnectionPoint)) {
            Resource diagramConnectionPointInverse = graph.getPossibleObject(diagramConnectionPoint, L0.InverseOf);
            graph.deny(diagramConnectionPoint);
            if (diagramConnectionPointInverse == null) continue;
            graph.deny(diagramConnectionPointInverse);
        }
        this.removeElement(graph);
    }
}

