/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class SCLChildRule
implements ChildRule {
    private Resource rule;

    public SCLChildRule(ReadGraph graph, Resource rule) {
        this.rule = rule;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    public Collection<Resource> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        Resource parentResource = parent instanceof Variable ? ((Variable)parent).getRepresents(graph) : (Resource)parent;
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Variable ruleVariable = Variables.getVariable((ReadGraph)graph, (Resource)this.rule);
        Function1 getChildren = (Function1)ruleVariable.getPossiblePropertyValue(graph, MOD.SCLChildRule_getChildren);
        if (getChildren == null) {
            return Collections.emptyList();
        }
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            sclContext.put((Object)"graph", (Object)graph);
            Collection collection = (Collection)getChildren.apply((Object)parentResource);
            return collection;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return null;
    }
}

