/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.SCLTypeUtils;
import org.simantics.scl.compiler.types.Type;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;

public class ComponentTypeSubstructure {
    public final THashMap<String, Type> properties;
    public final Map<String, ComponentTypeSubstructure> children;

    private ComponentTypeSubstructure(THashMap<String, Type> properties, Map<String, ComponentTypeSubstructure> children) {
        this.properties = properties;
        this.children = children;
    }

    public Pair<String, Type> possibleTypedRVI(String name) {
        int p;
        StringBuilder b = new StringBuilder();
        int namePos = 0;
        ComponentTypeSubstructure substructure = this;
        while ((p = name.indexOf(46, namePos)) >= 0) {
            String childName = name.substring(namePos, p);
            ComponentTypeSubstructure childSubstructure = substructure.children.get(childName);
            if (childSubstructure == null) {
                return null;
            }
            b.append('/').append(childName);
            namePos = p + 1;
            substructure = childSubstructure;
        }
        String propertyName = name.substring(namePos);
        Type type = (Type)substructure.properties.get((Object)propertyName);
        if (type == null) {
            return null;
        }
        b.append('#').append(propertyName);
        return Pair.make((Object)b.toString(), (Object)type);
    }

    public static ComponentTypeSubstructure forType(RequestProcessor processor, Resource componentType) throws DatabaseException {
        return (ComponentTypeSubstructure)processor.syncRequest((Read)new ResourceRead<ComponentTypeSubstructure>(componentType){

            public ComponentTypeSubstructure perform(ReadGraph graph) throws DatabaseException {
                THashMap children;
                THashMap properties = new THashMap();
                ComponentTypeSubstructure.collect(graph, this.resource, (THashMap<String, Type>)properties);
                for (Resource t : graph.getSupertypes(this.resource)) {
                    ComponentTypeSubstructure.collect(graph, t, (THashMap<String, Type>)properties);
                }
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                Resource composite = graph.getPossibleObject(this.resource, STR.IsDefinedBy);
                if (composite == null) {
                    children = Collections.emptyMap();
                } else {
                    Map childMap = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(composite));
                    children = new THashMap(childMap.size());
                    for (Map.Entry entry : childMap.entrySet()) {
                        Resource component = (Resource)entry.getValue();
                        Resource type = graph.getPossibleType(component, STR.Component);
                        if (type == null) continue;
                        children.put((String)entry.getKey(), ComponentTypeSubstructure.forType((RequestProcessor)graph, type));
                    }
                }
                return new ComponentTypeSubstructure(properties, (Map)children, null);
            }
        });
    }

    private static void collect(ReadGraph graph, Resource t, THashMap<String, Type> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource relation : graph.getObjects(t, L0.DomainOf)) {
            if (!graph.isSubrelationOf(relation, L0.HasProperty)) continue;
            PropertyInfo propertyInfo = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(relation));
            result.put((Object)propertyInfo.name, (Object)SCLTypeUtils.getType(propertyInfo));
        }
    }

    /* synthetic */ ComponentTypeSubstructure(THashMap tHashMap, Map map, ComponentTypeSubstructure componentTypeSubstructure) {
        this((THashMap<String, Type>)tHashMap, map);
    }
}

