/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.typicals;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.modeling.ui.documents.OpenPlainTextDocumentAdapter;
import org.simantics.modeling.ui.typicals.RuleChooserDialog;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.ui.ErrorLogger;

public class SyncActiveModelTypicals
extends AbstractHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Session session = Simantics.getSession();
        try {
            Resource[] activeModelTypicalTemplates = (Resource[])session.syncRequest((Read)new Read<Resource[]>(){

                public Resource[] perform(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                    Collection activeModels = (Collection)graph.syncRequest((Read)new ObjectsWithType(Simantics.getProjectResource(), L0X.Activates, SIMU.Model));
                    Instances query = (Instances)graph.adapt(MOD.MasterTypicalCompositeType, Instances.class);
                    HashSet<Resource> result = new HashSet<Resource>();
                    for (Resource activeModel : activeModels) {
                        Collection typicalComposites = query.find(graph, activeModel);
                        for (Resource typicalComposite : typicalComposites) {
                            for (Resource typicalDiagram : graph.getObjects(typicalComposite, MOD.CompositeToDiagram)) {
                                result.add(typicalDiagram);
                            }
                        }
                    }
                    return result.toArray(Resource.NONE);
                }
            });
            if (activeModelTypicalTemplates.length <= 0) {
                MessageDialog.openInformation((Shell)shell, (String)"No Typical Templates", (String)"The currently active model doesn't contain any typical diagram templates.");
                return null;
            }
            StringBuilder msg = new StringBuilder("Synchronizing ").append(activeModelTypicalTemplates.length).append(" typical template");
            if (activeModelTypicalTemplates.length > 1) {
                msg.append("s to all their instances.");
            } else {
                msg.append(" to all its instances.");
            }
            RuleChooserDialog.RuleResult result = RuleChooserDialog.choose(shell, msg.toString(), activeModelTypicalTemplates);
            if (result == null) {
                return null;
            }
            session.markUndoPoint();
            SyncTypicalTemplatesToInstances req = new SyncTypicalTemplatesToInstances(result.selectedRules, activeModelTypicalTemplates).logging(result.logging);
            session.syncRequest((Write)req);
            if (!result.logging) return null;
            Iterator iterator = req.logs.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                Resource log = (Resource)iterator.next();
                new OpenPlainTextDocumentAdapter().openEditor(log);
            }
        }
        catch (Exception e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }
}

