/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.preferences;

import java.util.HashMap;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.modeling.ui.preferences.DiagramPreferences;
import org.simantics.utils.page.PageDesc;

public final class DiagramPreferenceUtil {
    public static final String PLUGIN_ID = "org.simantics.modeling.ui";

    public static DiagramPreferences getDefaultPreferences() {
        return DiagramPreferenceUtil.getPreferences(DefaultScope.INSTANCE);
    }

    public static DiagramPreferences getPreferences() {
        return DiagramPreferenceUtil.getPreferences(InstanceScope.INSTANCE);
    }

    public static DiagramPreferences getPreferences(IScopeContext context) {
        IEclipsePreferences node = context.getNode(PLUGIN_ID);
        double gridSize = node.getDouble("grid.size", DiagramPreferences.DEFAULT_SNAP_GRID_SIZE.doubleValue());
        PageDesc pageDesc = DiagramPreferenceUtil.getPageDesc(node);
        boolean displayPage = node.getBoolean("page.display.size", DiagramPreferences.DEFAULT_DISPLAY_PAGE_SIZE.booleanValue());
        boolean displayMargins = node.getBoolean("page.display.margins", DiagramPreferences.DEFAULT_DISPLAY_MARGINS.booleanValue());
        boolean displayGrid = node.getBoolean("page.display.margins", DiagramPreferences.DEFAULT_DISPLAY_GRID.booleanValue());
        boolean displayRuler = node.getBoolean("page.display.margins", DiagramPreferences.DEFAULT_DISPLAY_RULER.booleanValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("grid.size", gridSize);
        map.put("page.default.size", pageDesc);
        map.put("page.display.size", displayPage);
        map.put("page.display.margins", displayMargins);
        map.put("page.display.grid", displayGrid);
        map.put("page.display.ruler", displayRuler);
        return new DiagramPreferences(node, map);
    }

    public static void setPreferences(DiagramPreferences prefs) {
        DiagramPreferenceUtil._setPreferences(InstanceScope.INSTANCE, prefs);
    }

    public static void flushPreferences(DiagramPreferences prefs) throws BackingStoreException {
        IEclipsePreferences p = DiagramPreferenceUtil._setPreferences(InstanceScope.INSTANCE, prefs);
        p.flush();
    }

    public static void setPreferences(IScopeContext context, DiagramPreferences prefs) {
        DiagramPreferenceUtil._setPreferences(context, prefs);
    }

    private static IEclipsePreferences _setPreferences(IScopeContext context, DiagramPreferences prefs) {
        IEclipsePreferences node = context.getNode(PLUGIN_ID);
        node.putDouble("grid.size", ((Double)prefs.get("grid.size")).doubleValue());
        node.put("page.default.size", PageDesc.serialize((PageDesc)((PageDesc)prefs.get("page.default.size"))));
        node.putBoolean("page.display.size", ((Boolean)prefs.get("page.display.size")).booleanValue());
        node.putBoolean("page.display.margins", ((Boolean)prefs.get("page.display.margins")).booleanValue());
        node.putBoolean("page.display.grid", ((Boolean)prefs.get("page.display.grid")).booleanValue());
        node.putBoolean("page.display.ruler", ((Boolean)prefs.get("page.display.ruler")).booleanValue());
        return node;
    }

    private static PageDesc getPageDesc(IEclipsePreferences node) {
        String desc = node.get("page.default.size", null);
        return PageDesc.deserialize((String)desc, (PageDesc)DiagramPreferences.DEFAULT_PAGE_SIZE);
    }
}

