/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.requests.Nodes;
import org.simantics.modeling.ui.pdf.DiagramPrinter;
import org.simantics.modeling.ui.pdf.NodeTree;
import org.simantics.modeling.ui.pdf.PDFExportPlan;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFExportPage
extends WizardPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFExportPage.class);
    protected Display display;
    protected PDFExportPlan exportModel;
    protected Combo modelSelector;
    protected SelectionListener modelSelectorListener;
    protected NodeTree nodeTree;
    protected CCombo exportLocation;
    protected ModifyListener exportLocationListener;
    protected Set<Node> selectedNodes;
    protected Label toFileLabel;
    protected boolean exportLocationTouchedByUser = false;

    protected PDFExportPage(PDFExportPlan model) {
        super("Export Diagrams to PDF", "Define Exported Items", null);
        this.exportModel = model;
        this.selectedNodes = this.exportModel.selectedNodeSet;
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label modelSelectorLabel = new Label(container, 0);
        modelSelectorLabel.setText("Model Selector:");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)modelSelectorLabel);
        this.modelSelector = new Combo(container, 2056);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.modelSelector);
        this.modelSelectorListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedResource data = (NamedResource)PDFExportPage.this.modelSelector.getData(String.valueOf(PDFExportPage.this.modelSelector.getSelectionIndex()));
                PDFExportPage.this.scheduleInitializeData(data);
            }
        };
        int i = 0;
        while (i < this.exportModel.selectableModels.size()) {
            NamedResource nr = this.exportModel.selectableModels.get(i);
            this.modelSelector.add(nr.getName());
            this.modelSelector.setData("" + i, (Object)nr);
            ++i;
        }
        this.modelSelector.addSelectionListener(this.modelSelectorListener);
        this.nodeTree = new NodeTree(container, this.selectedNodes);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.nodeTree);
        this.nodeTree.setSelectionChangeListener(this::validatePage);
        this.toFileLabel = new Label(container, 0);
        this.toFileLabel.setText("&To file:");
        this.exportLocation = new CCombo(container, 2048);
        this.exportLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
        for (String path : this.exportModel.recentLocations) {
            this.exportLocation.add(path);
        }
        this.exportLocationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PDFExportPage.this.exportLocationTouchedByUser = true;
                PDFExportPage.this.validatePage();
            }
        };
        this.exportLocation.addModifyListener(this.exportLocationListener);
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Browse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file;
                FileDialog dialog = new FileDialog(PDFExportPage.this.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.pdf"});
                dialog.setFilterNames(new String[]{"PDF Document"});
                String loc = PDFExportPage.this.exportLocation.getText();
                if (loc != null) {
                    Path p = new Path(loc);
                    File f = p.toFile();
                    if (f.isDirectory()) {
                        dialog.setFilterPath(f.toString());
                    } else if (f.isFile()) {
                        IPath path = p.removeLastSegments(1);
                        String name = p.lastSegment();
                        dialog.setFilterPath(path.toOSString());
                        dialog.setFileName(name);
                    } else {
                        dialog.setFilterPath(f.toString());
                        IPath path = p.removeLastSegments(1);
                        String name = p.lastSegment();
                        f = path.toFile();
                        if (f.isDirectory()) {
                            dialog.setFilterPath(path.toOSString());
                        }
                        dialog.setFileName(name);
                    }
                }
                if ((file = dialog.open()) == null) {
                    return;
                }
                PDFExportPage.this.exportLocation.setText(file);
                PDFExportPage.this.validatePage();
            }
        });
        final Button zoomToFitButton = new Button(container, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)zoomToFitButton);
        zoomToFitButton.setText("F&it by content");
        zoomToFitButton.setSelection(this.exportModel.fitContentToPageMargins);
        zoomToFitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.exportModel.fitContentToPageMargins = zoomToFitButton.getSelection();
            }
        });
        final Button attachWikiButton = new Button(container, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)attachWikiButton);
        attachWikiButton.setText("Attach &Wiki page");
        attachWikiButton.setSelection(this.exportModel.attachWiki);
        attachWikiButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.exportModel.attachWiki = attachWikiButton.getSelection();
            }
        });
        final Button addPageNumbers = new Button(container, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)addPageNumbers);
        addPageNumbers.setText("Add page &numbers");
        addPageNumbers.setSelection(this.exportModel.addPageNumbers);
        addPageNumbers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.exportModel.addPageNumbers = addPageNumbers.getSelection();
            }
        });
        this.setControl((Control)container);
        this.validatePage();
        this.scheduleInitializeData(this.exportModel.selection);
    }

    private void scheduleInitializeData(NamedResource modelSelection) {
        this.display.asyncExec(() -> {
            try {
                if (!this.nodeTree.isDisposed()) {
                    this.initializeData(modelSelection);
                }
            }
            catch (InterruptedException | DatabaseException e) {
                LOGGER.error("Input data initialization failed.", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Input data initialization failed.", e.getTargetException());
            }
        });
    }

    private NamedResource getSelectedModel() {
        int sel = this.modelSelector.getSelectionIndex();
        if (sel != -1) {
            NamedResource nr = (NamedResource)this.modelSelector.getData("" + sel);
            return nr;
        }
        return null;
    }

    private void setExportLocationWithoutNotification(String text) {
        this.exportLocation.removeModifyListener(this.exportLocationListener);
        this.exportLocation.setText(text);
        this.exportLocation.addModifyListener(this.exportLocationListener);
    }

    private void initializeData(final NamedResource modelSelection) throws DatabaseException, InvocationTargetException, InterruptedException {
        final HashSet toBeSelected = new HashSet();
        if (modelSelection != null) {
            long time = System.nanoTime();
            this.getWizard().getContainer().run(true, true, monitor -> {
                try {
                    try {
                        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Searching for exportable diagrams...", (int)100);
                        this.exportModel.sessionContext.getSession().syncRequest((Read)new ReadRequest(){

                            public void run(ReadGraph graph) throws DatabaseException {
                                CollectionResult coll = PDFExportPage.this.exportModel.nodes = DiagramPrinter.browse((IProgressMonitor)mon.newChild(100), (RequestProcessor)graph, new Resource[]{modelSelection.getResource()});
                                if (modelSelection.equals((Object)PDFExportPage.this.exportModel.initialModelSelection)) {
                                    HashSet<Resource> selectedResources = new HashSet<Resource>();
                                    for (Object o : PDFExportPage.this.exportModel.initialSelection.toList()) {
                                        Resource r = ResourceAdaptionUtils.toSingleResource(o);
                                        if (r == null) continue;
                                        selectedResources.add(r);
                                    }
                                    coll.walkTree(node -> {
                                        if (node.getDiagramResource() != null) {
                                            if (Nodes.parentIsInSet((Set)toBeSelected, (Node)node)) {
                                                toBeSelected.add(node);
                                            } else {
                                                for (Resource r : node.getDefiningResources()) {
                                                    if (!selectedResources.contains(r)) continue;
                                                    toBeSelected.add(node);
                                                }
                                            }
                                        }
                                        return true;
                                    });
                                }
                                PDFExportPage.this.exportModel.nodes = coll = coll.withRoots(Nodes.depthFirstFilter((Predicate)Nodes.DIAGRAM_RESOURCE_PREDICATE, (Collection)coll.roots));
                                if (toBeSelected.isEmpty()) {
                                    toBeSelected.addAll(coll.breadthFirstFlatten(CollectionResult.DIAGRAM_RESOURCE_FILTER));
                                }
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
            long endTime = System.nanoTime();
            if (this.exportModel.nodes != null) {
                LOGGER.info("Found " + this.exportModel.nodes.diagrams.size() + " diagrams in " + (double)(endTime - time) * 1.0E-9 + " seconds.");
            }
        }
        if (this.exportModel.nodes == null) {
            return;
        }
        this.selectedNodes.clear();
        this.selectedNodes.addAll(toBeSelected);
        this.nodeTree.setInput(this.exportModel.nodes);
        this.modelSelector.removeSelectionListener(this.modelSelectorListener);
        int selectedIndex = -1;
        int i = 0;
        while (i < this.modelSelector.getItemCount()) {
            Object obj = this.modelSelector.getData("" + i);
            if (ObjectUtils.objectEquals((Object)obj, (Object)modelSelection)) {
                selectedIndex = i;
            }
            ++i;
        }
        if (selectedIndex == -1 && this.modelSelector.getItemCount() > 0) {
            selectedIndex = 0;
        }
        if (selectedIndex != -1) {
            this.modelSelector.select(selectedIndex);
        }
        this.modelSelector.addSelectionListener(this.modelSelectorListener);
        this.validatePage();
    }

    void validatePage() {
        String exportLoc;
        int diagramCount = 0;
        Node singleDiagram = null;
        for (Node n : this.selectedNodes) {
            if (n.getDiagramResource() == null) continue;
            ++diagramCount;
            singleDiagram = n;
        }
        if (diagramCount == 0) {
            this.setMessage("Select the diagrams to export.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (!this.exportLocationTouchedByUser) {
            String generatedName = null;
            NamedResource nr = this.getSelectedModel();
            if (nr != null) {
                generatedName = diagramCount == 1 && singleDiagram != null ? String.valueOf(nr.getName()) + "-" + singleDiagram.getName() : nr.getName();
            }
            if (generatedName != null) {
                String name;
                block13: {
                    if (!FileUtils.isValidFileName(generatedName)) {
                        generatedName = (String)Bindings.STR_VARIANT.createUnchecked((Binding)Bindings.STRING, (Object)generatedName);
                    }
                    name = String.valueOf(generatedName) + ".pdf";
                    if (!this.exportModel.recentLocations.isEmpty()) {
                        for (String loc : this.exportModel.recentLocations) {
                            if (!loc.endsWith(name) || loc.equals(name)) continue;
                            name = loc;
                            break block13;
                        }
                        String firstLine = this.exportModel.recentLocations.iterator().next();
                        File f = new File(firstLine);
                        File parentFile = f.getParentFile();
                        if (parentFile != null) {
                            name = new File(f.getParentFile(), name).getAbsolutePath();
                        }
                    }
                }
                this.setExportLocationWithoutNotification(name);
            }
        }
        if ((exportLoc = this.exportLocation.getText()).isEmpty()) {
            this.setMessage("Select an export target file.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(exportLoc);
        if (file.exists()) {
            if (file.isDirectory()) {
                this.setErrorMessage("The target already exists and it is a directory.");
                this.setPageComplete(false);
                return;
            }
            if (!file.isFile()) {
                this.setErrorMessage("The target already exists and it is a not a regular file.");
                this.setPageComplete(false);
                return;
            }
        }
        this.exportModel.exportLocation = file;
        String msg = String.valueOf(diagramCount) + " diagrams selected for export.";
        this.setMessage(msg);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

