/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.requests.SetSubscriptionEnabled;
import org.simantics.modeling.ui.Activator;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class SetSubscriptionEnabledContribution
extends DynamicMenuContribution
implements IExecutableExtension {
    String name = "";
    ImageDescriptor image = null;
    boolean include = true;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Map) {
            Map args = (Map)data;
            this.name = (String)args.get("name");
            String imageId = (String)args.get("image");
            this.image = Activator.getDefault().getImageRegistry().getDescriptor(imageId);
            this.include = Boolean.parseBoolean((String)args.get("include"));
        }
    }

    private Collection<Resource> toSubscriptions(ReadGraph graph, Collection<Resource> resources) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        HashSet<Resource> result = new HashSet<Resource>(resources.size());
        for (Resource o : resources) {
            if (!graph.isInstanceOf(o, mod.Subscription)) continue;
            result.add(o);
        }
        return result;
    }

    protected Object[] getSelectedObjects() {
        return ResourceAdaptionUtils.toResources((Object)this.getSelection());
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] elements) throws DatabaseException {
        Resource[] resources = (Resource[])elements;
        if (resources.length == 0) {
            return new IContributionItem[0];
        }
        final Collection<Resource> subscriptions = this.toSubscriptions(graph, Arrays.asList(resources));
        if (subscriptions.isEmpty()) {
            return new IContributionItem[0];
        }
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        boolean foundNonMatchingEnableStates = false;
        for (Resource subscription : subscriptions) {
            Boolean isIncluded = (Boolean)graph.getPossibleRelatedValue(subscription, mod.Subscription_Enabled);
            if (isIncluded == null) {
                isIncluded = Boolean.TRUE;
            }
            if (isIncluded == this.include) continue;
            foundNonMatchingEnableStates = true;
        }
        if (!foundNonMatchingEnableStates) {
            return new IContributionItem[0];
        }
        return new IContributionItem[]{new ActionContributionItem((IAction)new Action(this.name, this.image){

            public void run() {
                Session session = Simantics.peekSession();
                if (session == null) {
                    return;
                }
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        new SetSubscriptionEnabled(subscriptions, (this).SetSubscriptionEnabledContribution.this.include).perform(graph);
                    }
                });
            }
        })};
    }
}

