/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.label;

import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * @author Tuukka Lehtonen
 */
public enum SubscriptionLabelRule implements LabelRule {

    INSTANCE;

    public static SubscriptionLabelRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object input) throws DatabaseException {
        Resource subscription = (Resource) input;

        ModelingResources MOD = ModelingResources.getInstance(graph);
        String rep = LabelerUtil.safeStringRepresentation(graph, subscription);
        Boolean enabled = graph.getPossibleRelatedValue(subscription, MOD.Subscription_Enabled, Bindings.BOOLEAN);
        if (!Boolean.TRUE.equals(enabled)) {
            rep += " (disabled)";
        }

        return ArrayMap.make(ColumnKeys.KEYS_SINGLE, rep);
    }

}
