/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

public class ToggleExternalFlag extends AbstractHandler implements IElementUpdater {

    private static Resource getFlagResource(ISelection sel) {
        Resource r = AdaptionUtils.adaptToSingle(sel, Resource.class);
        return r;
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection(event);
        final Resource resource = getFlagResource(sel);
        if (resource == null)
            return null;

        Simantics.getSession().asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph g) throws DatabaseException {
                DiagramResource dr = DiagramResource.getInstance(g);
                Boolean ext = g.hasStatement(resource, dr.ExternalFlag);
                if (ext)
                    g.deny(resource, dr.ExternalFlag);
                else
                    g.claim(resource, dr.ExternalFlag, resource);
            }
        });

        return null;
    }

    @Override
    public void updateElement(UIElement element, @SuppressWarnings("rawtypes") Map parameters) {
        ICommandService commandService = (ICommandService) PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.simantics.modeling.ui.toggleExternalFlag");

        // Get a State object for the toggleSubscriptionGroup command
        State state = command.getState("org.simantics.modeling.ui.toggleExternalFlag.state");
        if (state == null) {
            state = new State();
            state.setValue(Boolean.TRUE);
            command.addState("org.simantics.modeling.ui.toggleExternalFlag.state", state);
        }

        // Get the current value for the State object
        Session s = Simantics.peekSession();
        if (s != null) {
            Boolean value = Boolean.TRUE;
            IWorkbenchSite site = (IWorkbenchSite) parameters.get("org.eclipse.ui.part.IWorkbenchPartSite");
            ISelectionProvider sp = site.getSelectionProvider();
            if (sp != null) {
                final Resource resource = getFlagResource(sp.getSelection());
                if (resource != null) {
                    try {
                        value = s.syncRequest(new Read<Boolean>() {
                            @Override
                            public Boolean perform(ReadGraph graph) throws DatabaseException {
                                DiagramResource dr = DiagramResource.getInstance(graph);
                                return Boolean.valueOf(graph.hasStatement(resource, dr.ExternalFlag));
                            }
                        });
                    } catch (DatabaseException e) {
                        ErrorLogger.defaultLogError(e);
                    }
                }
            }
            state.setValue(value);
        }

        Boolean checked = (Boolean) state.getValue();
        element.setChecked(checked);
        element.setIcon(checked ? Activator.TICK_ICON : null);
    }

}

