/*******************************************************************************
 * Copyright (c) 2013, 2015 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - adaption to SCLModuleEditor/TextEditor
 *******************************************************************************/
package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.layer0.Layer0;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor.SharedTextColorsNew;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;

/**
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen (extended from SCLModuleEditor)
 */
public class ProceduralComponentTypeCodeEditor extends SCLModuleEditor {

    private ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR =
            Combinators.compose(
                    InputValidationCombinators.hasURI(),
                    Combinators.compose(
                            InputValidationCombinators.partialFunction(Layer0.URIs.PropertyOf),
                            InputValidationCombinators.extractInputResource()
                    )
            );

    public ProceduralComponentTypeCodeEditor() {
        super();
    }

    @Override
    protected void preInitialize() {
        //showOverviewRuler();
        Display display = PlatformUI.getWorkbench().getDisplay();
        SCLSourceViewerConfigurationNew sourceViewerConfiguration = new SCLSourceViewerConfigurationNew(resourceManager);
        setDocumentProvider(new ProceduralComponentTypeCodeDocumentProvider(sourceViewerConfiguration, display, this));
        setSourceViewerConfiguration(sourceViewerConfiguration);
        
    }

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return INPUT_VALIDATOR;
    }

}