/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.Resource;
import org.simantics.modeling.ui.diagram.PageSettingsDialog;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.ui.workbench.IResourceEditorInput;


/**
 * A Handler that shows PageSettings Dialog for DiagramViewer
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 */
public class PageSettingsHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart ap = HandlerUtil.getActivePart(event);
        if (ap instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor) ap;
            IResourceEditorInput input = (IResourceEditorInput)editor.getEditorInput();
            Resource diagramResource = input.getResource();
            if (diagramResource == null)
                return null;

            PageSettingsDialog dialog = new PageSettingsDialog(diagramResource, ap.getSite().getShell());
            if (dialog.open() == PageSettingsDialog.OK) {
                dialog.applySettings();
            }
        }
        return null;
    }

}
