/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.actions.IActionCategory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.action.PriorityAction;

public class ModeledDoubleClickActions implements IDoubleClickAction, IExecutableExtension {

    private Set<String> browseContexts = defaultBrowseContexts;

    final static public Set<String> defaultBrowseContexts = Collections.singleton(ProjectResource.URIs.ProjectDoubleClickActionContext);
    
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    	if(data instanceof String) {
    		String str = (String)data;
    		String[] parms = str.split(";"); //$NON-NLS-1$
    		for(String parm : parms) {
    			String[] keyValue = parm.split("="); //$NON-NLS-1$
    			if(keyValue.length == 2) {
    				String key = keyValue[0].trim();
    				if("context".equals(key)) { //$NON-NLS-1$
    					browseContexts = Collections.singleton(keyValue[1]);
    				}
    			}
    		}
    	}
    }
    
    public Collection<String> getBrowseContexts() {
        return browseContexts;
    }
    
    public Collection<Resource> getBrowseContextResources(ReadGraph graph) throws DatabaseException {
        Collection<String> names = getBrowseContexts(); 
        ArrayList<Resource> result = new ArrayList<Resource>(names.size());
        for(String name : names)
            result.add(graph.getResource(name));
        return result;
    }
	
    @Override
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
    	
        ReadGraph g = e.getGraph();
        final Resource resource = ResourceAdaptionUtils.toSingleResource(e.getResource());
        if (resource == null)
            return;

        Collection<PriorityAction> actions = g.syncRequest(new ResourceRead<Collection<PriorityAction>>(resource) {

			@Override
			public Collection<PriorityAction> perform(ReadGraph graph) throws DatabaseException {
				
		    	List<NodeContext> contexts = Collections.singletonList(NodeContextBuilder.buildWithInput(resource));
		    	
		        try {

		        	NodeContext nodeContext = contexts.get(0);
		        	
		            ActionBrowseContext defaultContext = ActionBrowseContext.create(graph,
		                    getBrowseContextResources(graph));
		            
		            ActionBrowseContext browseContext = defaultContext;//ActionBrowseContext.get(graph, nodeContext, defaultContext);
		            
		            Map<IActionCategory, List<Action>> result = browseContext.getActions(graph, nodeContext, contexts);
		            Map<IActionCategory, List<Action>> current = result;
		            
		            for(int i=0;i<contexts.size();i++) {

		                defaultContext = ActionBrowseContext.create(graph,
		                        getBrowseContextResources(graph));
		                
		                browseContext = ActionBrowseContext.get(graph, nodeContext, defaultContext);
		                
		                Map<IActionCategory, List<Action>> m = browseContext.getActions(graph, contexts.get(i), contexts);

		                result = new HashMap<IActionCategory, List<Action>>();
		                
		                for(Map.Entry<IActionCategory, List<Action>> entry : m.entrySet()) {
		                	List<Action> exist = current.get(entry.getKey());
		                	if (exist == null)
		                		continue;

		                	ArrayList<Action> l = new ArrayList<Action>();
		                	for(Action e : exist) {
		                		String id = e.getId();
		                		boolean found = false;
		                		for(Action a : entry.getValue()) {
		                			if(id.equals(a.getId())) {
		                				found = true;
		                				break;
		                			}
		                		}
		                		if(found) l.add(e);
		                	}
		                	if(!l.isEmpty()) result.put(entry.getKey(), l);
		                }
		                
		                current = result;
		            	
		            }
		            
		            return toContributionItems(result);
		            
		        } catch (InvalidContribution e) {
		            e.printStackTrace();
		        }
		        
		        return Collections.emptyList();
		        
			}
        	
        });
        
        for(PriorityAction act : actions)
        	e.add(act);
        
    }
    
    private static Collection<PriorityAction> toContributionItems(
            Map<IActionCategory, List<Action>> map) {

    	if(map.isEmpty())
            return Collections.emptyList();
        
        IActionCategory[] categories = map.keySet().toArray(new IActionCategory[map.size()]);
        Arrays.sort(categories, IActionCategory.ACTION_CATEGORY_COMPARATOR);
        
        ArrayList<PriorityAction> items = new ArrayList<PriorityAction>();
        for(IActionCategory category : categories) {
            List<Action> actions = map.get(category);
            for(Action act : actions)
                items.add(new PriorityAction(PriorityAction.HIGH+10) {
                    @Override
                    public void run() {
                    	act.run();
                    }
                });
        }
        return items;
    }    

}
