/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.tests.commands;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleURIVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.diagram.adapter.DisposableListener;
import org.simantics.diagram.adapter.DisposableListenerAdapter;
import org.simantics.modeling.tests.traits.SingleResourceTrait;

public class WriteState
extends WriteCommand<CommandSequenceEnvironment> {
    private static final long TIMEOUT = 5000000000L;
    public transient SingleResourceTrait run;
    public transient String rvi;
    public transient Object value;
    public transient Binding binding;

    public WriteState(SingleResourceTrait run, String rvi, Object value, Binding binding) {
        this.run = run;
        this.rvi = rvi;
        this.value = value;
        this.binding = binding;
    }

    public void run(CommandSequenceEnvironment environment) throws DatabaseException {
        long start = System.nanoTime();
        long current = System.nanoTime();
        DisposableListenerAdapter listener = new DisposableListenerAdapter();
        try {
            while (current - start < 5000000000L) {
                boolean success = (Boolean)environment.getSession().sync((WriteInterface)new WriteResultRequest<Boolean>((DisposableListener)listener){
                    private final /* synthetic */ DisposableListener val$listener;
                    {
                        this.val$listener = disposableListener;
                    }

                    public Boolean perform(WriteGraph graph) throws DatabaseException {
                        Variable state = (Variable)graph.syncRequest((Read)new PossibleURIVariable(String.valueOf(graph.getURI(WriteState.this.run.getResource((ReadGraph)graph))) + WriteState.this.rvi), (Listener)this.val$listener);
                        if (state == null) {
                            return false;
                        }
                        state.setValue(graph, WriteState.this.value, WriteState.this.binding);
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Set value"));
                        return true;
                    }
                });
                if (success) {
                    return;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    throw new DatabaseException((Throwable)e1);
                }
                current = System.nanoTime();
            }
            throw new DatabaseException("Timeout writing " + this.rvi);
        }
        finally {
            listener.disposeListener();
        }
    }
}

