package org.simantics.modeling.tests.traits;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;

abstract public class AbstractSingleResourceTrait implements SingleResourceTrait {
	
	@Override
	public Resource getResource() throws DatabaseException {
		return Simantics.sync(new UniqueRead<Resource>() {

			@Override
			public Resource perform(ReadGraph graph) throws DatabaseException {
				return getResource(graph);
			}
			
		});
	}
	
	@Override
	public SingleResourceTrait child(String path) {
		return new UriResourceTrait(this, path);
	}
	
}
