package org.simantics.modeling.tests.commands;

import org.simantics.db.testing.common.Command;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.traits.SingleModelTrait;
import org.simantics.modeling.utils.BatchValidations;

public class RunAllBatchValidations extends Command<ModelingCommandSequenceTest> {

	transient private SingleModelTrait model; 
	
	public RunAllBatchValidations(SingleModelTrait model) {
		this.model = model;
	}
	
	@Override
	public void run(ModelingCommandSequenceTest environment) throws Exception {
		
        BatchValidations.runAll(null, model.getResource());
		
	}

}
