package org.simantics.modeling.tests.commands;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;


public class AddModule extends ResourceWriteCommand<ModelingCommandSequenceTest> implements SingleResourceTrait {

	private AddDiagram diagram;
	private SingleResourceTrait type;
	private double x,y;
	
	public AddModule(AddDiagram diagram, SingleResourceTrait type, double x, double y) {
		this.diagram = diagram;
		this.type = type;
		this.x = x;
		this.y = y;
	}
	
	public AddModule(AddDiagram diagram, Resource type, double x, double y) {
		this.diagram = diagram;
		this.type = new SingleResourceTraitImpl(type);
		this.x = x;
		this.y = y;
	}

	@Override
	protected Resource run(WriteGraph graph, ModelingCommandSequenceTest environment) throws DatabaseException {
		
		Layer0 L0 = Layer0.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        G2DResource G2D = G2DResource.getInstance(graph);
		
		Resource diagramResource = diagram.getResource();
		
		// Diagram
        Resource resource = graph.newResource();
        graph.claim(resource, L0.InstanceOf, null, type.getResource(graph));
        graph.claimLiteral(resource, DIA.HasTransform, G2D.Transform, new double[] { 1, 0, 0, 1, x, y }, Bindings.DOUBLE_ARRAY);
        graph.claim(resource, L0.PartOf, diagramResource);

		AddElement.claimFreshElementName(graph, diagramResource, resource);
        OrderedSetUtils.addFirst(graph, diagramResource, resource);
        
        return resource;
        
	}
	
}