package org.simantics.modeling.tests.commands;

import java.util.Collection;
import java.util.Map;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ModelInstances;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;

public class ActivateProfile extends WriteCommand<CommandSequenceEnvironment> {

	private LoadDiagram diagram;
	private String profileName;
	private Collection<Resource> entries;
	
	public ActivateProfile(LoadDiagram diagram, String profileName, Collection<Resource> entries) {
		this.diagram = diagram;
		this.profileName = profileName;
		this.entries = entries;
	}
	
	@Override
	public void run(CommandSequenceEnvironment environment) throws DatabaseException {
		
    	ICanvasContext ctx = diagram.getContext();

        Resource runtime = DiagramNodeUtil.getRuntime(ctx);
        
        DiagramResource DIA = DiagramResource.getInstance(Simantics.getSession());

        Map<String, Resource> profiles = Simantics.getSession().sync(new ModelInstances(diagram.getResource(), DIA.Profile));
        Resource profile = profiles.get(profileName);

        DiagramNodeUtil.activateProfileWithEntries(runtime, profile, entries);
		
	}

}