/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.function;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.util.Bean;

public class FlagTableInfo extends Bean.Id {
	@Identifier
	private double[] transform = new double[] { 1.0, 0.0, 0.0, 1.0, 0.0, 0.0 };
	@Identifier
	private Float width = 0.0F;
	@Identifier
	private Float rowHeight = 10.0F;
	@Identifier
	private Integer rowCount = -1;
	@Identifier
	private Float weightTotal = 0.0F;
	@Identifier
	@Optional
	private Integer alignment = null;
	@Identifier
	public List<FlagTableColumnInfo> columns = new ArrayList<FlagTableColumnInfo>();

	public transient AffineTransform affineTransform;

	public FlagTableInfo(){
	}
	
	public void addColumn(FlagTableColumnInfo column){
		columns.add(column);
	}
	
	public void setWeightTotal(Float total){
		weightTotal = total;
	}

	public double[] getTransform(){
		return transform;
	}
	
	public void setTransform(double[] transform){
		this.transform = transform;
	}

	public Float getWidth() {
		return width;
	}

	public void setWidth(Float width) {
		this.width = width;
	}

	public Float getRowHeight() {
		return rowHeight;
	}

	public void setRowHeight(Float rowHeigth) {
		this.rowHeight = rowHeigth;
	}

	public Integer getRowCount() {
		return rowCount;
	}

	public void setRowCount(Integer rowCount) {
		this.rowCount = rowCount;
	}

	public Integer getAlignment() {
		return alignment;
	}

	public void setAlignment(Integer alignment) {
		this.alignment = alignment;
	}

	public Float getWeightTotal() {
		return weightTotal;
	}
}
