/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.function;

import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.util.Bean;

public class FlagTableColumnInfo extends Bean {
    public static final Integer TYPE_NORMAL        = 0;
    public static final Integer TYPE_ROW_NUMBERING = 1;
	
	private Float weight = 0.0F;
	private Integer type = TYPE_NORMAL;

	/**
	 * Numbering start offset for RowNumberColumns.
	 */
	@Optional
	private Integer startOffset;

	@Identifier
	public List<MonitorInfo> columnDatas = new ArrayList<MonitorInfo>();
	@Identifier
	public List<MonitorInfo> columnHeaders = new ArrayList<MonitorInfo>();

	public void addColumnData(MonitorInfo columnData){
		columnDatas.add(columnData);
	}

	public void addColumnHeader(MonitorInfo columnData){
		columnHeaders.add(columnData);
	}

	public Float getWeight() {
		return weight;
	}

	public void setWeight(Float weight) {
		this.weight = weight;
	}

	public FlagTableColumnInfo(Float weight){
		this.weight = weight;
		
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getStartOffset() {
		return startOffset;
	}

	public void setStartOffset(Integer startOffset) {
		this.startOffset = startOffset;
	}

}
