/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.template2d.ui.function.LinkSVGImage;

public class SVGImagePasteHandler extends DefaultPasteHandler {

	public SVGImagePasteHandler(Resource resource) {
		super(resource);
	}

	@Override
	public void onPasteBegin(WriteGraph graph) {
		
	}

	@Override
	public void execute(WriteGraph graph, TransferableGraph1 tg,
		Resource resource, IImportAdvisor advisor) throws DatabaseException {
	}

	@Override
    public Collection<Resource> pasteObject(WriteGraph graph, Set<Representation> object, PasteEventHandler handler) throws DatabaseException {
		Collection<Resource> result = new ArrayList<Resource>(); 
        TransferableGraph1 tg = ClipboardUtils.accept(graph, object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
        if (tg != null) {
            DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor((Resource)getAdapter(Resource.class)); 
            try {
                onPaste(graph, advisor, object);
            } catch (Throwable e) {
            }
        }
        return result;
    }

    @Override
	public void onPaste(WriteGraph graph, IImportAdvisor2 advisor, Set<Representation> representations) throws DatabaseException {
		
		final Resource parent = advisor.getTarget();
		final Collection<Resource> child = ClipboardUtils.accept(representations, SimanticsKeys.KEY_COPY_RESOURCES);
		if(child != null) {
		    if(child.size() == 1) {
		        LinkSVGImage.linkSVGImage(graph, parent, child.iterator().next());
		    }
		}
		
    }

	@Override
	public void onPasteEnd(WriteGraph graph){
		
	}
}
