package org.simantics.modeling.rules;

import gnu.trove.set.hash.THashSet;

import java.util.Collection;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.structural.stubs.StructuralResource2;

public class RelatedDiagramConnections {

	ReadGraph g;
	StructuralResource2 sr;
	DiagramResource dr;
	
	THashSet<Resource> connections = new THashSet<Resource>();
	THashSet<Resource> connectionJoins = new THashSet<Resource>();
	THashSet<Resource> outputConnectors = new THashSet<Resource>();
		
	public RelatedDiagramConnections(ReadGraph g) {
		this.g = g;
		this.sr = StructuralResource2.getInstance(g);
		this.dr = DiagramResource.getInstance(g);
	}

	public void addConnection(Resource connection) throws DatabaseException {
		if(connections.add(connection)) {
			for(Statement hasConnector : g.getStatements(connection, dr.HasConnector)) {
				Resource connector = hasConnector.getObject();
				for(Resource flag : g.getObjects(connector, sr.Connects)) {
					if(g.isInstanceOf(flag, dr.Flag)) {
						for(Resource join : g.getObjects(flag, dr.FlagIsJoinedBy))
							addConnectionJoin(join);
					}
				}
				if (g.isSubrelationOf(hasConnector.getPredicate(), dr.HasTailConnector)) {
					outputConnectors.add(connector);
				}
			}
		}
	}
	
	public void addConnectionJoin(Resource join) throws DatabaseException {
		if(connectionJoins.add(join)) {
			for(Resource flag : g.getObjects(join, dr.JoinsFlag))
				for(Resource connector : g.getObjects(flag, sr.IsConnectedTo))
					for(Resource connection : g.getObjects(connector, dr.IsConnectorOf))
						addConnection(connection);
		}
	}

	public static Collection<Resource> getRelatedDiagramConnections(ReadGraph g, Resource connection) throws DatabaseException {
		RelatedDiagramConnections p = new RelatedDiagramConnections(g);
		p.addConnection(connection);
		return p.connections;
	}

	public Set<Resource> getDiagramConnections() {
		return connections;
	}

	public Set<Resource> getOutputConnectors() {
		return outputConnectors;
	}

}
