package org.simantics.modeling.migration;

 import java.io.PrintWriter;
import java.util.Collection;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStateKeys;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.migration.NullWriter;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.modeling.ModelingUtils;

/**
 * Runs
 * {@link ModelingUtils#createMissingGUIDs(IProgressMonitor, WriteGraph, Resource)}
 * for all imported models.
 * 
 * @author Tuukka Lehtonen
 */
public enum GuidCreationStep implements MigrationStep {

    INSTANCE;

    public static GuidCreationStep get() {
        return INSTANCE;
    }

    @Override
    public void applyTo(final IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        final Collection<Resource> roots = state.getProperty(MigrationStateKeys.CURRENT_ROOT_RESOURCES);
        if (roots.isEmpty())
            return;
        final PrintWriter log = MigrationUtils.getProperty(state, MigrationStateKeys.MESSAGE_LOG_WRITER, NullWriter.PRINT_INSTANCE);

        session.sync(new DelayedWriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                create(monitor, graph, roots, log);
            }
        });
    }

    private static void create(IProgressMonitor monitor, WriteGraph graph, Collection<Resource> roots, PrintWriter log) throws DatabaseException {
        log.println("## Creating missing GUID identifiers ##");
        Layer0Utils.setDependenciesIndexingDisabled(graph, true);
        ModelingUtils.createMissingGUIDs(monitor, graph, roots);
    }

}