/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.mapping;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.mapping.constraint.instructions.TypedBracketInstruction.CreationInstruction;
import org.simantics.modeling.services.ComponentNamingUtil;
import org.simantics.modeling.services.NamingException;
import org.simantics.project.IProject;

public class NamingCreationInstruction extends CreationInstruction {

    IProject project;
    int configurationRoot;
    int lComponentType;
    int lConfiguration;

    public NamingCreationInstruction(IProject project, int configurationRoot, int variableId, int componentType,
            int configuration) {
        super(variableId);
        this.project = project;
        this.configurationRoot = configurationRoot;
        lComponentType = componentType;
        lConfiguration = configuration;
    }

    @Override
    public Resource create(WriteGraph g, Object[] bindings) throws DatabaseException {
        Resource componentType = (Resource) bindings[lComponentType];
        Resource configuration = (Resource) bindings[lConfiguration];

        try {
        	CommonDBUtils.selectClusterSet(g, configuration);
            String proposition = ComponentNamingUtil.findFreshInstanceName(g, project, (Resource)bindings[configurationRoot], configuration, componentType);
        	Layer0 b = Layer0.getInstance(g);
            Resource result = GraphUtils.create(g,
                    b.HasName, proposition
            );
            Layer0Utils.claimNewIdentifier(g, result, true);
            return result;
        } catch (NamingException e1) {
            throw new DatabaseException(e1);
        }
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        super.mapVariables(map);
        lComponentType = map.get(lComponentType);
        lConfiguration = map.get(lConfiguration);
        configurationRoot = map.get(configurationRoot);
    }
    
    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
    	reads.add(lComponentType);
    	reads.add(lConfiguration);
    	reads.add(configurationRoot);
    }

}
