/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;

/**
 * @author Tuukka Lehtonen
 */
public class ReferenceElementRemover extends ElementRemover {

    public ReferenceElementRemover(Resource referenceElement) {
        super(referenceElement);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);

        Resource referencedComponent = graph.getPossibleObject(resource, MOD.HasParentComponent);
        Resource referenceRelation = graph.getPossibleObject(resource, MOD.HasReferenceRelation);
        //System.out.println("references component : " + NameUtils.getSafeName(graph, referencedComponent));
        //System.out.println("reference relation: " + NameUtils.getSafeName(graph, referenceRelation));

        if (referencedComponent != null && referenceRelation != null) {
            // Make sure that all referenceRelations from parentComponent are
            // removed since removing this reference element will also remove
            // the referenceRelation which would break the statements into
            // unusable form if the relation was still used anywhere.
            graph.deny(referencedComponent, referenceRelation);
        }

        // Only after successfully denying all uses of referenceRelation
        // can we delete the reference element itself.
        super.remove(graph);
    }

}
