package org.simantics.modeling;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.hints.IHintContext;

/**
 * TODO: the IHintContext is just a nasty vimpautus to provide data to the
 * monitor drop participant
 * 
 * A property variable must have at least a visualized part,
 * {@link #getModificationVariable()} may return null.
 */
public interface PropertyVariables extends IHintContext {

    /**
     * @return the container of the property
     */
    Variable getContainer();

    /**
     * @return the configuration space variable for the property
     */
    Variable getConfiguration();

    /**
     * @return the variable to read labeling/other visualisation information
     *         from
     */
    Variable getVisualVariable();

    /**
     * @return the variable into which to write modifications to this property
     */
    Variable getModificationVariable();

    /**
     * @return
     */
    String getSuffix();

    /**
     * To support indexing.
     * 
     * @param suffix
     * @return
     */
    PropertyVariables withSuffix(String suffix);

    /**
     * @return a new instance where {@link #getVisualVariable()} and
     *         {@link #getModificationVariable()} are both browsed with a suffix
     *         attached to this property variable. {@link #getContainer()}
     *         returns the same value. If this instance has no suffix, this will
     *         be returned.
     */
    PropertyVariables resolved(ReadGraph graph) throws DatabaseException;

}
