/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.writer;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public interface GraphWriter {

    ReadGraph getGraph(); // Returns read-only graph
	
	GraphWriter flush() throws DatabaseException;
	
	// Begin
	GraphWriter create() throws DatabaseException;
	GraphWriter create(Resource type) throws DatabaseException;
	GraphWriter create(int clusterHint) throws DatabaseException;
	GraphWriter create(int clusterHint, Resource type) throws DatabaseException;
	GraphWriter create(String name, Resource type) throws DatabaseException;
	GraphWriter create(int clusterHint, String name, Resource type) throws DatabaseException;
	GraphWriter createLiteral(Object value, Resource dataType) throws DatabaseException;
	GraphWriter createLiteral(int clusterHint, Object value, Resource dataType) throws DatabaseException;
	GraphWriter createInverse(Resource r) throws DatabaseException;
	GraphWriter createInverse(int clusterHint, Resource r) throws DatabaseException;
	GraphWriter handle(Resource s);
	
	// Edit
	GraphWriter let(Resource p, Resource o) throws DatabaseException;
	//GraphWriter letWithoutInverse(Resource p, Resource o);
	GraphWriter let(int clusterHint, Resource p, Object value, Resource dataType) throws DatabaseException;	
	GraphWriter let(Resource p, Object value, Resource dataType) throws DatabaseException;
	//GraphWriter letWithoutInverse(Resource p, Object value, Resource dataType);
	GraphWriter stat(Resource s, Resource p, Resource o) throws DatabaseException;
	Resource    get();
	
}
