/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.writer;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class DirectGraphWriter extends GraphWriterPartial {

	Resource current;
	WriteGraph wg;
		
	public DirectGraphWriter(WriteGraph graph) {
		super(graph);
		this.wg = graph;
		this.current = null;
	}

    @Override
    public GraphWriter create() throws DatabaseException {
        current = wg.newResource();
        return this;
    }

	@Override
	public GraphWriter create(Resource type) throws DatabaseException {
		current = wg.newResource();
    	Layer0 b = Layer0.getInstance(wg);
		wg.claim(current, b.InstanceOf, null, type);
		return this;
	}

	@Override
	public Resource get() {
		return current;
	}

	@Override
	public GraphWriter handle(Resource s) {
		current = s;
		return this;
	}

	@Override
	public GraphWriter let(Resource p, Resource o) throws DatabaseException {
		if(current == null)
			throw new RuntimeException("Should call create or handle before let.");
		wg.claim(current, p, o);
		return this;
	}

	@Override
	public GraphWriter let(Resource p, Object value, Resource dataType) throws DatabaseException {
		if(current == null)
			throw new RuntimeException("Should call create or handle before let.");
		Resource temp = wg.newResource();		
		wg.claim(temp, l0.InstanceOf, null, dataType);
		wg.claimValue(temp, value);
		wg.claim(current, p, temp);
		return this;
	}

	@Override
	public GraphWriter flush() throws DatabaseException {
		wg.flushCluster();
		return this;
	}
	
    @Override
    public GraphWriter createLiteral(Object value, Resource dataType) throws DatabaseException {
        current = wg.newResource();
        wg.claim(current, l0.InstanceOf, null, dataType);
        wg.claimValue(current, value);
        return this;
    }

    @Override
    public GraphWriter createInverse(Resource r) throws DatabaseException {
        current = wg.newResource();
        wg.claim(r, l0.InverseOf, current);
        return this;
    }

}
