/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.predicates;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class SuperRelation extends UnaryPredicate {

	Resource superrelation;

	public SuperRelation(Resource superrelation) {
		this.superrelation = superrelation;
	}

	@Override
	public Collection<Resource> getResources(ReadGraph g) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
		return g.isSubrelationOf(resource, superrelation);
	}

	@Override
	public boolean supportsUnboundedQuery() {
		return false;
	}

	@Override
	public void add(WriteGraph g, Resource r) throws DatabaseException {
		if(!g.isSubrelationOf(r, superrelation)) {
	    	Layer0 b = Layer0.getInstance(g);
			g.claim(r, b.SubrelationOf, superrelation);
			if(!g.hasStatement(r, b.InverseOf)) {
				Resource invR = g.newResource();
				g.claim(r, b.InverseOf, invR);
				g.claim(invR, b.SubrelationOf, g.getInverse(superrelation));
			}
		}
	}

	@Override
	public void remove(WriteGraph g, Resource r) throws DatabaseException {
		// FIXME not implemented correctly
    	Layer0 b = Layer0.getInstance(g);
		if(g.isSubrelationOf(r, superrelation))
			g.denyStatement(r, b.SubrelationOf, superrelation);
	}

	@Override
	public boolean supportsAddition() {
		return true;
	}

	@Override
	public boolean supportsRemoval() {
		return false;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((superrelation == null) ? 0 : superrelation.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SuperRelation other = (SuperRelation) obj;
		if (superrelation == null) {
			if (other.superrelation != null)
				return false;
		} else if (!superrelation.equals(other.superrelation))
			return false;
		return true;
	}
	
}
