/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.operations;

import org.simantics.db.Session;
import org.simantics.utils.datastructures.persistent.IContextMap;

/**
 * To define an icon for an IOperation, define a resource adapter for the
 * <code>org.simantics.ui.icons.ImageDescriptorProvider</code>
 * interface.
 */
public interface IOperation {

	public static final Object SUBJECT = new Object() {
		public String toString() { return "SUBJECT"; }
	};
	
	public static final Object PROJECT = new Object() {
		public String toString() { return "PROJECT"; }
	};
	
	String getName();
	void exec(Session session, IContextMap context);
	
}
