/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.collections;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.operation.OperationResource;
import org.simantics.utils.datastructures.persistent.IContextMap;

public class ContextualListUtils {
	public static void fill(ReadGraph g, Resource r, IContextMap parameters, Collection<Resource> c) throws DatabaseException {		
		OperationResource OP = OperationResource.getInstance(g);
		if(g.isInstanceOf(r, OP.AbstractContextualList))
			g.adapt(r, IContextualList.class).fill(g, parameters, c);
		else
			c.add(r);
	}
}
