/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.binaryPredicates;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public abstract class BinaryPredicate implements IBinaryPredicate {
	
	@Override
	public IBinaryPredicate inverse(ReadGraph g) throws DatabaseException {
		return new InversePredicate(this);
	}
	
	public String toString(ReadGraph g) throws DatabaseException {
		return getClass().getName();
	}
	
}
