/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jdbc.variable;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.jdbc.PGDataSource;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.jdbc.variable.JDBCNode;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCNodeManagerSupport
implements StandardNodeManagerSupport<JDBCNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCNodeManagerSupport.class);
    private String id;
    private PGDataSource dataSource;
    private String channelName;

    public JDBCNodeManagerSupport(String id, PGDataSource dataSource, String channelName) {
        this.id = id;
        this.dataSource = dataSource;
        this.channelName = channelName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getEngineValue(JDBCNode node) throws NodeManagerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting value for {}", (Object)node.getName());
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PGConnection connection = (PGConnection)this.dataSource.getConnection();){
                PreparedStatement ps = connection.prepareStatement("SELECT value->'value' FROM simantics_table WHERE key IN ('" + node.getName() + "');");
                ResultSet rs = ps.executeQuery();
                if (rs.next()) return rs.getObject(1);
                if (!LOGGER.isDebugEnabled()) return null;
                LOGGER.debug("no value for query {}", (Object)ps.toString());
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get value for {}", (Object)node.getName(), (Object)e);
            throw new NodeManagerException("Failed to get value for " + node.getName(), (Throwable)e);
        }
    }

    public Binding getEngineBinding(JDBCNode node) throws NodeManagerException {
        return Bindings.OBJECT;
    }

    public void setEngineValue(JDBCNode node, Object value) throws NodeManagerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting value for {} to {}", (Object)node.getName(), value);
        }
        this.setValueImpl(node.getName(), value);
    }

    private void setValueImpl(String name, Object value) throws NodeManagerException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PGConnection connection = (PGConnection)this.dataSource.getConnection();){
                PreparedStatement statement = connection.prepareStatement("INSERT INTO simantics_table VALUES (?, ?::JSON) ON CONFLICT (key) DO UPDATE SET value= ?::JSON");
                statement.setString(1, name);
                statement.setObject(2, "{\"value\": " + value.toString() + "}");
                statement.setObject(3, "{\"value\": " + value.toString() + "}");
                statement.executeUpdate();
                this.doNotify(connection, name);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to set value for {} to {}", new Object[]{name, value, e});
            throw new NodeManagerException("Failed to set value for " + name + " to " + String.valueOf(value), (Throwable)e);
        }
    }

    private void doNotify(PGConnection connection, String name) throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Notifying change {} to channel {}", (Object)name, (Object)this.channelName);
        }
        Statement statement = connection.createStatement();
        String sql = "NOTIFY " + this.channelName + ", '" + name + "'";
        statement.execute(sql);
        statement.close();
    }

    public String getName(JDBCNode node) {
        return node.getName();
    }

    public Map<String, JDBCNode> getChildren(JDBCNode node) {
        return Collections.emptyMap();
    }

    public Map<String, JDBCNode> getProperties(JDBCNode node) {
        HashMap<String, JDBCNode> properties = new HashMap<String, JDBCNode>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PGConnection connection = (PGConnection)this.dataSource.getConnection();){
                Statement st = connection.createStatement();
                ResultSet executeQuery = st.executeQuery("SELECT key FROM simantics_table");
                while (executeQuery.next()) {
                    String key = executeQuery.getString(1);
                    properties.put(key, new JDBCNode(key));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not read properties", (Throwable)e);
        }
        return properties;
    }
}

