/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.common.BatchIssueValidationContext;
import org.simantics.issues.common.SelectedModelBatchIssueSources;
import org.simantics.issues.ui.handler.RunActiveValidations;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.ExceptionUtils;

public class UpdateIssuesForOpenDiagrams
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Runnable postValidation = null;
        try {
            UpdateIssuesForOpenDiagrams.update(postValidation);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        catch (PartInitException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }

    public static void update(Runnable postValidation) throws DatabaseException, PartInitException {
        IWorkbenchWindow[] windows;
        final ArrayList<IResourceEditorInput> inputs = new ArrayList<IResourceEditorInput>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow wb = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = wb.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorInput input = ref.getEditorInput();
                    if (input instanceof IResourceEditorInput) {
                        IResourceEditorInput in = (IResourceEditorInput)input;
                        inputs.add(in);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        final TreeSet compositesToValidate = new TreeSet();
        final ArrayList<BatchIssueSource> validations = new ArrayList<BatchIssueSource>();
        final ArrayList activeModels = new ArrayList();
        final BatchIssueValidationContext context = new BatchIssueValidationContext();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Resource project = Simantics.getProjectResource();
                        Session session = Simantics.getSession();
                        activeModels.addAll((Collection)session.syncRequest((Read)new ActiveModels(project)));
                        if (activeModels.size() != 1) {
                            return;
                        }
                        try {
                            RunActiveValidations.toBatchIssueSources((RequestProcessor)session, (Collection)session.syncRequest((Read)new SelectedModelBatchIssueSources((Resource)activeModels.iterator().next())), validations);
                            session.syncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                                    for (IResourceEditorInput input : inputs) {
                                        Resource model;
                                        Resource composite;
                                        Resource in = input.getResource();
                                        if (!graph.isInstanceOf(in, DIA.Diagram) || (composite = graph.getPossibleObject(in, MOD.DiagramToComposite)) == null || !activeModels.contains(model = (Resource)graph.sync((ReadInterface)new PossibleModel(composite)))) continue;
                                        compositesToValidate.add(composite);
                                    }
                                    context.contexts = compositesToValidate;
                                    if (!compositesToValidate.isEmpty()) {
                                        context.domain = ModelTransferableGraphSourceRequest.getDomainOnly((RequestProcessor)graph, (IProgressMonitor)monitor, (Collection)compositesToValidate);
                                    }
                                }
                            });
                        }
                        catch (DatabaseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.logAndShowError((Throwable)e.getTargetException());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (!context.contexts.isEmpty() && activeModels.size() == 1) {
            RunActiveValidations.run(postValidation, validations, context);
        }
    }
}

